Imports System.Web.Services
Imports System.Data.SqlClient
Imports System.Web.Services.Protocols
Imports System.Xml.Serialization
Imports System.Xml

<WebService(Namespace := "http://tempuri.org/")> _
Public Class Authentication
    Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Web Services Designer.
        InitializeComponent()

        'Add your own initialization code after the InitializeComponent() call

    End Sub

    'Required by the Web Services Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Web Services Designer
    'It can be modified using the Web Services Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        'CODEGEN: This procedure is required by the Web Services Designer
        'Do not modify it using the code editor.
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

#End Region

    <WebMethod()> Public Function Logon(ByVal UserName As String, ByVal Password As String) As String
        'Determine if the user credentials are valid
        If (ValidUserPassword(UserName, Password) = True) Then
            Return CreateSession(UserName)
        Else
            Throw HotelAuthenticationSOAPException("Invalid user name or password")
        End If
    End Function

    '*****************************************************************************************
    ' NAME:         ValidUserPassword
    ' DESCRIPTION:  Verifies that a row (user) exists in the DemoUsers table and that the 
    '               password passed in matches the password in the table.  Returns 
    '               TRUE if user exists in DemoUsers table and FALSE if they do not.
    '*****************************************************************************************
    Private Function ValidUserPassword(ByVal UserName As String, ByVal Password As String) As Boolean
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        Dim strSQL As String = "SELECT * FROM DemoUsers WHERE UserName = '" & UserName & "' AND Password = '" & Password & "'"
        Dim objSelectCommand As SqlCommand = New SqlCommand(strSQL, objConnection)
        Dim bolReturnValue As Boolean

        objSelectCommand.Connection.Open()
        Dim objDataReader As SqlDataReader
        objDataReader = objSelectCommand.ExecuteReader()
        If (objDataReader.Read() = True) Then
            'Row exists, assume valid user/password
            bolReturnValue = True
        Else
            'Row does not exist, no valid user
            bolReturnValue = False
        End If
        objSelectCommand.Connection.Close()

        Return bolReturnValue
    End Function

    '*****************************************************************************************
    ' NAME:         CreateSession
    ' DESCRIPTION:  Creates a valid session row in the DemoSessions table for the specified
    '               UserID.
    '*****************************************************************************************
    Private Function CreateSession(ByVal UserName As String) As String
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        objConnection.Open()

        'Get the UserID from the DemoUsers table, by UserName
        Dim intUserID As Integer
        Dim strSQL As String = "SELECT UserID FROM DemoUsers WHERE UserName = '" & UserName & "'"
        Dim objSelectCommand As SqlCommand = New SqlCommand(strSQL, objConnection)

        intUserID = objSelectCommand.ExecuteScalar().ToString()

        'Create a new Session ID and insert it into the DemoSessions table
        Dim strGUID As System.Guid = System.Guid.NewGuid()
        strSQL = "INSERT INTO DemoSessions(UserID, SessionID) VALUES ('" & intUserID & "','" & strGUID.ToString() & "')"
        Dim objInsertCommand As SqlCommand = New SqlCommand(strSQL, objConnection)

        objInsertCommand.ExecuteNonQuery()

        objConnection.Close()

        Return strGUID.ToString()

    End Function

    '*****************************************************************************************
    ' NAME:         HotelAuthenticationSOAPException
    ' DESCRIPTION:  Returns a custom SOAP exception with the specified error message.
    '*****************************************************************************************
    Private Function HotelAuthenticationSOAPException(ByVal Message As String) As SoapException
        'Raise SOAP exception, with description
        Dim doc As New System.Xml.XmlDocument()
        Dim node As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            SoapException.DetailElementName.Name, SoapException.DetailElementName.Namespace)

        Dim details As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            "HotelAuthenticationFault", "http://tempuri.org/")

        details.InnerText = Message
        node.AppendChild(details)

        Return New SoapException("Fault occurred", SoapException.ClientFaultCode, Context.Request.Url.AbsoluteUri, node)
    End Function

End Class
